do
	
	local function GetTotalCount(itemId)
		local realm = GetRealmName();
		
		local totalCount = 0;
		
		-- Process all charracters on this account (GetCharacters defaults to THIS_ACCOUNT)
		for characterName, character in pairs(DataStore:GetCharacters(realm, nil)) do
			-- Get only useful info (currency / gear shouldn't contain the stuff we are interested in)
			local bag, bank = DataStore:GetContainerItemCount(character, itemId);
			local auctionHouse = DataStore:GetAuctionHouseItemCount(character, itemId);
			local mail = DataStore:GetMailItemCount(character, itemId);
			
			totalCount = totalCount + bag + bank + auctionHouse + mail;
		end
		
		return totalCount or -1;
	end
	
	local function GetCharacterCount(itemId)
		local character = DataStore:GetCharacter();
		
		local bag, bank = DataStore:GetContainerItemCount(character, itemId);
		local auctionHouse = DataStore:GetAuctionHouseItemCount(character, itemId);
		local mail = DataStore:GetMailItemCount(character, itemId);
		
		return bag, bank, auctionHouse, mail;
	end
	
	local function IsEnabled()
		return (DataStore and DataStore.GetContainerItemCount and DataStore.GetAuctionHouseItemCount and DataStore.GetMailItemCount);
	end
	
	IMRegisterItemCountAddon("DataStore (current account only)", GetTotalCount, GetCharacterCount, IsEnabled);
	
end
